<?php
header("Content-type: application/json");
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: OPTIONS,GET,POST,PUT,DELETE");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

$body = file_get_contents("php://input");

$query = $_SERVER["QUERY_STRING"];

if($_SERVER["REQUEST_METHOD"] == "POST") {
    print_r(simular($query));
}
    function doRequest($endpoint, $headers, $post) {
        $url= 'https://app.parcelow.com'.$endpoint;
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    if ($post) {
        $post = json_encode($post, JSON_UNESCAPED_SLASHES);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $post);
    }
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
    $result = curl_exec($ch);
    curl_close($ch);
    return json_decode($result);
}

function oauthAccessToken() {
    $requestParam = array( 'client_id' => 70,
        'client_secret' => "H8cp0sFjRnJ6U0fR7gqrwwgPHzLF9ntjaOpaoNri",
        'grant_type' => "client_credentials");
    $header = array("Accept: application/json",
        "Content-Type: application/json",
        "X-Requested-With: XMLHttpRequest");
    $response = doRequest("/oauth/token", $header, $requestParam);
    if (!isset($response->access_token)) {
        return '';
    }
    return $response->access_token;
}

function simular($valor_real) {
    $curl = curl_init();

    curl_setopt_array($curl, array(
        CURLOPT_URL => 'https://app.parcelow.com/api/simulate?amount=' . $valor_real,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'GET',
        CURLOPT_HTTPHEADER => array(
            'Authorization: Bearer ' . oauthAccessToken(),
            'Accept: application/json',
            'Content-Type: application/json'
        ),
    ));
    $response = curl_exec($curl);
    curl_close($curl);

    $json = json_decode($response);
    $valor_dolar = $json->data->dolar;
    $taxa = 0.38;
    $total_convertido = ($valor_real / $valor_dolar);

    $result = ($total_convertido - ($total_convertido * $taxa) / 100);

    return resultadoFinal($result);
}

function resultadoFinal($result) {
    $curl = curl_init();

    curl_setopt_array($curl, array(
        CURLOPT_URL => 'https://app.parcelow.com/api/simulate?amount=' . $result,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'GET',
        CURLOPT_HTTPHEADER => array(
            'Authorization: Bearer ' . oauthAccessToken(),
            'Accept: application/json',
            'Content-Type: application/json'
        ),
    ));
    $response = curl_exec($curl);
    curl_close($curl);
    $json = json_decode($response);
    $total_parcelado = $json->data->creditcard->installments[11]->monthly;
    return $total_parcelado;
}

